/** !------------------------------------------------------------------------->
*
*  @file PduR_Cfg_generated.h
*
*  @creationDate 22 November 2024 11:42:31
*
*  @brief Generated PduR configuration header file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*!-------------------------------------------------------------------------->*/
#ifndef _PDUR_CFG_GENERATED_H_
#define _PDUR_CFG_GENERATED_H_

/*------------------------------------------------------------------------------------------------*\
  DEFINES
\*------------------------------------------------------------------------------------------------*/

/* Definition of all supported operation modes. */
#define PDUR_GATEWAY_OPERATION      STD_OFF
#define PDUR_COM_SUPPORT            STD_ON
#define PDUR_IPDUM_SUPPORT          STD_OFF
#define PDUR_SECOC_SUPPORT          STD_OFF
#define PDUR_J1939TP_SUPPORT        STD_OFF
#define PDUR_SD_SUPPORT             STD_OFF
#define PDUR_MULTICAST_TOIF_SUPPORT STD_OFF
#define PDUR_MULTICAST_TOTP_SUPPORT STD_OFF
#define PDUR_CANNM_SUPPORT          STD_OFF
#define PDUR_CANIF_SUPPORT          STD_ON
#define PDUR_LINIF_SUPPORT          STD_OFF
#define PDUR_SOAD_SUPPORT           STD_OFF
#define PDUR_DEV_ERROR_DETECT       STD_OFF
#define PDUR_ZERO_COST_OPERATION    STD_OFF

#define PDUR_MODULE_INIT_STRUCTURE \
{ \
    { \
        CanIf_Transmit, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0 \
    } ,  \
    { \
        0, \
        Com_TriggerTransmit, \
        0, \
        Com_RxIndication, \
        0, \
        0, \
        0, \
        0, \
        0 \
    }  \
}

#define PDUR_TARGET_MODULE_CANIF_10692_11337 0
#define PDUR_TARGET_MODULE_COM_10692_11337 1
#define PDUR_TARGET_MODULE_NONE 255

#define PDUR_TX_AngVel_Compressor_10692_11337 ((PduIdType) 0)
#define PDUR_TX_EPower_Compressor_10692_11337 ((PduIdType) 1)
#define PDUR_TX_i_battery_10692_11337 ((PduIdType) 2)
#define PDUR_TX_p_chiller_10692_11337 ((PduIdType) 3)
#define PDUR_TX_p_cond_10692_11337 ((PduIdType) 4)
#define PDUR_TX_PJoule_battery_10692_11337 ((PduIdType) 5)
#define PDUR_TX_T_battery1_10692_11337 ((PduIdType) 6)
#define PDUR_TX_T_battery2_10692_11337 ((PduIdType) 7)
#define PDUR_TX_T_battery3_10692_11337 ((PduIdType) 8)
#define PDUR_TX_T_battery4_10692_11337 ((PduIdType) 9)
#define PDUR_TX_T_coolant_battery_in_10692_11337 ((PduIdType) 10)
#define PDUR_TX_T_coolant_inverter_out_10692_11337 ((PduIdType) 11)
#define PDUR_TX_T_inverter_10692_11337 ((PduIdType) 12)
#define PDUR_TX_T_motor_10692_11337 ((PduIdType) 13)
#define PDUR_TX_Torque_Compressor_10692_11337 ((PduIdType) 14)

#define PDUR_NUM_TX_PATHS 15


#define PDUR_TX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_AngVel_Compressor_11217_10692_11337 \
        }, \
        1, \
        0, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_EPower_Compressor_11208_10692_11337 \
        }, \
        1, \
        1, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_i_battery_11207_10692_11337 \
        }, \
        1, \
        2, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_p_chiller_11205_10692_11337 \
        }, \
        1, \
        3, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_p_cond_11204_10692_11337 \
        }, \
        1, \
        4, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_PJoule_battery_11203_10692_11337 \
        }, \
        1, \
        5, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_battery1_11198_10692_11337 \
        }, \
        1, \
        6, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_battery2_11197_10692_11337 \
        }, \
        1, \
        7, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_battery3_11196_10692_11337 \
        }, \
        1, \
        8, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_battery4_11195_10692_11337 \
        }, \
        1, \
        9, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_coolant_battery_in_11194_10692_11337 \
        }, \
        1, \
        10, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_coolant_inverter_out_11193_10692_11337 \
        }, \
        1, \
        11, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_inverter_11192_10692_11337 \
        }, \
        1, \
        12, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_T_motor_11191_10692_11337 \
        }, \
        1, \
        13, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337, \
            Com_TX_Torque_Compressor_11190_10692_11337 \
        }, \
        1, \
        14, \
    }  \
}

#define PDUR_TX_ENDPOINTS \
{ \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_AngVel_Compressor_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_EPower_Compressor_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_i_battery_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_p_chiller_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_p_cond_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_PJoule_battery_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_battery1_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_battery2_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_battery3_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_battery4_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_coolant_battery_in_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_coolant_inverter_out_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_inverter_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_T_motor_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10692_11337, \
        CanIf_ThermalCANcomplete_Torque_Compressor_FrameTrig \
    }  \
}



/* Mapping of Interface RX_INDICATION PDU IDs to RX_INDICATION table entries */
#define PDUR_RX_cmd_battery_pump_10692_11337_CanIf_Com ((PduIdType) 0)
#define PDUR_RX_cmd_chiller_bypass_10692_11337_CanIf_Com ((PduIdType) 1)
#define PDUR_RX_cmd_comp_10692_11337_CanIf_Com ((PduIdType) 2)
#define PDUR_RX_cmd_fan_10692_11337_CanIf_Com ((PduIdType) 3)
#define PDUR_RX_cmd_heater_10692_11337_CanIf_Com ((PduIdType) 4)
#define PDUR_RX_cmd_motor_pump_10692_11337_CanIf_Com ((PduIdType) 5)
#define PDUR_RX_cmd_parallel_serial_10692_11337_CanIf_Com ((PduIdType) 6)
#define PDUR_RX_cmd_rad_bypass_10692_11337_CanIf_Com ((PduIdType) 7)
#define PDUR_RX_I_traction_10692_11337_CanIf_Com ((PduIdType) 8)
#define PDUR_RX_Q_charger_10692_11337_CanIf_Com ((PduIdType) 9)
#define PDUR_RX_Q_dcdc_10692_11337_CanIf_Com ((PduIdType) 10)
#define PDUR_RX_Q_inverter_10692_11337_CanIf_Com ((PduIdType) 11)
#define PDUR_RX_Q_motor_10692_11337_CanIf_Com ((PduIdType) 12)
#define PDUR_RX_v_vehicle_10692_11337_CanIf_Com ((PduIdType) 13)
#ifndef PDUR_RX_PDUID_NONE
#define PDUR_RX_PDUID_NONE ((PduIdType) -1)
#endif
#define PDUR_NUM_RX_PATHS 14

/* Rx routing table definition. */
#define PDUR_RX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_battery_pump_11216_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_chiller_bypass_11215_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_comp_11214_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_fan_11213_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_heater_11212_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_motor_pump_11211_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_parallel_serial_11210_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_cmd_rad_bypass_11209_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_I_traction_11206_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_Q_charger_11202_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_Q_dcdc_11201_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_Q_inverter_11200_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_Q_motor_11199_10692_11337 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10692_11337,\
            Com_RX_v_vehicle_11189_10692_11337 \
        } \
    }  \
}
#endif /* _PDUR_CFG_GENERATED_H_ */

